clear all
set more off


*==============================================================
*					USA
*==============================================================
cd "C:\Dropbox\Oli\Hysteresis\workfiles_Oct_2013\"
use wf_step1001.dta, clear
capture cd "C:\Dropbox\Oli\Hysteresis\workfiles_Oct_2013\figures"

*** note that we exclude US and Canada from this
keep if smpl1==1

keep if country=="US"

gen ue3_rate=ue2_rate
replace ue3_rate=ue_rate if ue3_rate==. & ue_rate~=.

keep country nuts ue3_rate age_total year

twoway 	(line ue3_rate year if nuts=="US: California" & year>=1970 & year<=1995, lcolor(black) lwidth(thick)) ///
		(line ue3_rate year if nuts=="US: East North Central" & year>=1970 & year<=1995, lcolor(red) lpattern(shortdash)) ///
		(line ue3_rate year if nuts=="US: East South Central" & year>=1970 & year<=1995, lcolor(green) lpattern(longdash)) ///
		(line ue3_rate year if nuts=="US: Middle Atlantic States" & year>=1970 & year<=1995, lcolor(blue) lpattern(longdash_dot)) ///
		(scatter ue3_rate year if nuts=="US: New England" & year>=1970 & year<=1995, msymbol(d) mfcolor(white) connect(direct) mcolor(cyan) lcolor(cyan) lpattern(solid)) ///
		(line ue3_rate year if nuts=="US: Northwest" & year>=1970 & year<=1995, lcolor(orange) lpattern(dash)) ///
		(line ue3_rate year if nuts=="US: Rocky Mountain state" & year>=1970 & year<=1995, lcolor(brown) lpattern(longdash)) ///
		(line ue3_rate year if nuts=="US: South Atlantic" & year>=1970 & year<=1995, lcolor(pink) lpattern(dash_dot)) ///
		(scatter ue3_rate year if nuts=="US: West North Central" & year>=1970 & year<=1995,  msymbol(x) connect(direct) mcolor(magenta) lcolor(magenta) lpattern(solid)) ///
		(scatter ue3_rate year if nuts=="US: West South Central" & year>=1970 & year<=1995, msymbol(o) connect(direct) mcolor(emerald) lcolor(emerald) lpattern(solid)) ///
		, xlabel(1970(5)1995) ylabel(0(2)12) ytitle("unemployment rate" " ") xtitle("") ///
		legend( label(1 "California") ///
				label(2 "East N. Central") /// 
				label(3 "East S. Central") /// 
				label(4 "Mid Atlantic") /// 
				label(5 "New England") /// 
				label(6 "Northwest") /// 
				label(7 "Rocky Mountain") /// 
				label(8 "South Atlantic") /// 
				label(9 "West N. Central") /// 
				label(10 "West S. Central")  ///
				rows(4))	///
		subtitle("USA") ///		
		saving(fig_ts_US.gph, replace)	
		graph export fig_ts_US.emf, replace
  
				

*==============================================================
*					Germany
*==============================================================
cd "C:\Dropbox\Oli\Hysteresis\workfiles_Oct_2013\"
use wf_step1001.dta, clear
capture cd "C:\Dropbox\Oli\Hysteresis\workfiles_Oct_2013\figures"

*** note that we exclude US and Canada from this
keep if country=="DE"
keep if nuts_level==1
gen ue3_rate=ue2_rate
replace ue3_rate=ue_rate if ue3_rate==. & ue_rate~=.


keep country nuts ue3_rate age_total year 

twoway 	(line ue3_rate year if nuts=="DE1" & year>=1970 & year<=1995, lcolor(black) lwidth(thick)) ///
		(line ue3_rate year if nuts=="DE2" & year>=1970 & year<=1995, lcolor(red) lpattern(shortdash)) ///
		(line ue3_rate year if nuts=="DE5" & year>=1970 & year<=1995, lcolor(green) lpattern(longdash)) ///
		(line ue3_rate year if nuts=="DE6" & year>=1970 & year<=1995, lcolor(blue) lpattern(longdash_dot)) ///
		(scatter ue3_rate year if nuts=="DE7" & year>=1970 & year<=1995, msymbol(d) mfcolor(white) connect(direct) mcolor(cyan) lcolor(cyan) lpattern(solid)) ///
		(line ue3_rate year if nuts=="DE9" & year>=1970 & year<=1995, lcolor(orange) lpattern(dash)) ///
		(line ue3_rate year if nuts=="DEA" & year>=1970 & year<=1995, lcolor(brown) lpattern(longdash)) ///
		(line ue3_rate year if nuts=="DEB" & year>=1970 & year<=1995, lcolor(pink) lpattern(dash_dot)) ///
		(scatter ue3_rate year if nuts=="DEC0" & year>=1970 & year<=1995,  msymbol(x) connect(direct) mcolor(magenta) lcolor(magenta) lpattern(solid)) ///
		(scatter ue3_rate year if nuts=="DEF0" & year>=1970 & year<=1995, msymbol(o) connect(direct) mcolor(emerald) lcolor(emerald) lpattern(solid)) ///
		, xlabel(1970(5)1995) ylabel(0(2)12) ytitle("unemployment rate" " ") xtitle("") ///
		legend( label(1 "Baden-Wrttemberg") ///
				label(2 "Bayern") /// 
				label(3 "Bremen") /// 
				label(4 "Hamburg") /// 
				label(5 "Hessen") /// 
				label(6 "Niedersachsen") /// 
				label(7 "Nordrhein-Westfahlen") /// 
				label(8 "Rheinland-Pfalz") /// 
				label(9 "Saarland") /// 
				label(10 "Schleswig-Holstein")  ///
				rows(4))	///
		subtitle("Germany") ///		
		saving(fig_ts_DE.gph, replace)		
  		graph export fig_ts_DE.emf, replace

				
	


*==============================================================
*					France
*==============================================================
cd "C:\Dropbox\Oli\Hysteresis\workfiles_Oct_2013\"
use wf_step1001.dta, clear
capture cd "C:\Dropbox\Oli\Hysteresis\workfiles_Oct_2013\figures"

*** note that we exclude US and Canada from this
keep if country=="FR"
keep if nuts_level==1
gen ue3_rate=ue2_rate
replace ue3_rate=ue_rate if ue3_rate==. & ue_rate~=.


keep country nuts ue3_rate age_total year 

twoway 	(line ue3_rate year if nuts=="FR1" & year>=1970 & year<=1995, lcolor(black) lwidth(thick)) ///
		(line ue3_rate year if nuts=="FR2" & year>=1970 & year<=1995, lcolor(red) lpattern(shortdash)) ///
		(line ue3_rate year if nuts=="FR3" & year>=1970 & year<=1995, lcolor(green) lpattern(longdash)) ///
		(line ue3_rate year if nuts=="FR4" & year>=1970 & year<=1995, lcolor(blue) lpattern(longdash_dot)) ///
		(scatter ue3_rate year if nuts=="FR5" & year>=1970 & year<=1995, msymbol(d) mfcolor(white) connect(direct) mcolor(cyan) lcolor(cyan) lpattern(solid)) ///
		(line ue3_rate year if nuts=="FR6" & year>=1970 & year<=1995, lcolor(orange) lpattern(dash)) ///
		(line ue3_rate year if nuts=="FR7" & year>=1970 & year<=1995, lcolor(brown) lpattern(longdash)) ///
		(line ue3_rate year if nuts=="FR8" & year>=1970 & year<=1995, lcolor(pink) lpattern(dash_dot)) ///
		, xlabel(1970(5)1995) ylabel(0(2)20) ytitle("unemployment rate" " ") xtitle("") ///
		legend( label(1 "le-de-France") ///
				label(2 "Paris basin") /// 
				label(3 "Nord-Pas-de-Calais") /// 
				label(4 "East") /// 
				label(5 "West") /// 
				label(6 "South West") /// 
				label(7 "Centre East") /// 
				label(8 "Mediterranean") /// 
				rows(4))	///
		subtitle("France") ///		
		saving(fig_ts_FR.gph, replace)		
  		graph export fig_ts_FR.emf, replace

				

					 
	
*==============================================================
*					Italy (NUTS1)
*==============================================================
cd "C:\Dropbox\Oli\Hysteresis\workfiles_Oct_2013\"
use wf_step1001.dta, clear
capture cd "C:\Dropbox\Oli\Hysteresis\workfiles_Oct_2013\figures"

*** note that we exclude US and Canada from this
keep if country=="IT"
keep if nuts_level==1
gen ue3_rate=ue2_rate
replace ue3_rate=ue_rate if ue3_rate==. & ue_rate~=.


keep country nuts ue3_rate age_total year 

twoway 	(line ue3_rate year if nuts=="ITC" & year>=1970 & year<=1995, lcolor(black) lwidth(thick)) ///
		(line ue3_rate year if nuts=="ITF" & year>=1970 & year<=1995, lcolor(red) lpattern(shortdash)) ///
		(line ue3_rate year if nuts=="ITG" & year>=1970 & year<=1995, lcolor(green) lpattern(longdash)) ///
		(line ue3_rate year if nuts=="ITH" & year>=1970 & year<=1995, lcolor(blue) lpattern(longdash_dot)) ///
		(scatter ue3_rate year if nuts=="ITI" & year>=1970 & year<=1995, msymbol(d) mfcolor(white) connect(direct) mcolor(cyan) lcolor(cyan) lpattern(solid)) ///
		, xlabel(1970(5)1995) ylabel(0(2)24) ytitle("unemployment rate" " ") xtitle("") ///
		legend( label(1 "North West") ///
				label(2 "South") /// 
				label(3 "Islands") /// 
				label(4 "North East") /// 
				label(5 "Centre") /// 
				rows(2))	///
		subtitle("Italy") ///		
		saving(fig_ts_IT.gph, replace)		
  		graph export fig_ts_IT.emf, replace

				
				
 *==============================================================
*					Belgium
*==============================================================
cd "C:\Dropbox\Oli\Hysteresis\workfiles_Oct_2013\"
use wf_step1001.dta, clear
capture cd "C:\Dropbox\Oli\Hysteresis\workfiles_Oct_2013\figures"

*** note that we exclude US and Canada from this
keep if country=="BE"
gen ue3_rate=ue2_rate
replace ue3_rate=ue_rate if ue3_rate==. & ue_rate~=.


keep country nuts ue3_rate age_total year 

twoway 	(line ue3_rate year if nuts=="BE1" & year>=1970 & year<=1995, lcolor(black) lwidth(thick)) ///
		(line ue3_rate year if nuts=="BE21" & year>=1970 & year<=1995, lcolor(red) lpattern(shortdash)) ///
		(line ue3_rate year if nuts=="BE22" & year>=1970 & year<=1995, lcolor(green) lpattern(longdash)) ///
		(line ue3_rate year if nuts=="BE23" & year>=1970 & year<=1995, lcolor(blue) lpattern(longdash_dot)) ///
		(scatter ue3_rate year if nuts=="BE24" & year>=1970 & year<=1995, msymbol(d) mfcolor(white) connect(direct) mcolor(cyan) lcolor(cyan) lpattern(solid)) ///
		(line ue3_rate year if nuts=="BE25" & year>=1970 & year<=1995, lcolor(orange) lpattern(dash)) ///
		(line ue3_rate year if nuts=="BE31" & year>=1970 & year<=1995, lcolor(brown) lpattern(longdash)) ///
		(line ue3_rate year if nuts=="BE32" & year>=1970 & year<=1995, lcolor(pink) lpattern(dash_dot)) ///
		(scatter ue3_rate year if nuts=="BE33" & year>=1970 & year<=1995,  msymbol(x) connect(direct) mcolor(magenta) lcolor(magenta) lpattern(solid)) ///
		(scatter ue3_rate year if nuts=="BE34" & year>=1970 & year<=1995, msymbol(o) connect(direct) mcolor(emerald) lcolor(emerald) lpattern(solid)) ///
		(scatter ue3_rate year if nuts=="BE35" & year>=1970 & year<=1995, msymbol(t) mfcolor(white)  connect(direct) mcolor(black) lcolor(black) lpattern(dash)) ///		
		, xlabel(1970(5)1995) ylabel(0(2)18) ytitle("unemployment rate" " ") xtitle("") ///
		legend( label(1 "Bruxelles") ///
				label(2 "Antwerpen") /// 
				label(3 "Limburg") /// 
				label(4 "Oost-Vlaanderen") /// 
				label(5 "Vlaams-Brabant") /// 
				label(6 "West-Vlaanderen") /// 
				label(7 "Brabant Wallon") /// 
				label(8 "Hainaut") /// 
				label(9 "Lige") /// 
				label(10 "Luxembourg (BE)") /// 
				label(11 "Namur")  ///
				rows(4))                                  
									
		
      

twoway 	(line ue3_rate year if nuts=="BE1" & year>=1970 & year<=1995, lcolor(black) lwidth(thick)) ///
		(line ue3_rate year if nuts=="BE2" & year>=1970 & year<=1995, lcolor(red) lpattern(shortdash)) ///
		(line ue3_rate year if nuts=="BE3" & year>=1970 & year<=1995, lcolor(blue) lpattern(longdash)) ///
		, xlabel(1970(5)1995) ylabel(0(2)18) ytitle("unemployment rate" " ") xtitle("") ///
		legend( label(1 "Bruxelles") ///
				label(3 "Wallonne") /// 
				label(2 "Vlaams gewest") /// 
				rows(4))     	///
		subtitle("Belgium") ///		
		saving(fig_ts_BE.gph, replace)		
        graph export fig_ts_BE.emf, replace
                       
							
			
			
 *==============================================================
*					Canada
*==============================================================
cd "C:\Dropbox\Oli\Hysteresis\workfiles_Oct_2013\"
use wf_step1001.dta, clear
capture cd "C:\Dropbox\Oli\Hysteresis\workfiles_Oct_2013\figures"

*** note that we exclude US and Canada from this
keep if country=="CA"
gen ue3_rate=ue2_rate
replace ue3_rate=ue_rate if ue3_rate==. & ue_rate~=.


keep country nuts ue3_rate age_total year 

twoway 	(line ue3_rate year if nuts=="CA: Alberta" & year>=1970 & year<=1995, lcolor(black) lwidth(thick)) ///
		(line ue3_rate year if nuts=="CA: British Columbia" & year>=1970 & year<=1995, lcolor(red) lpattern(shortdash)) ///
		(line ue3_rate year if nuts=="CA: Manitoba" & year>=1970 & year<=1995, lcolor(green) lpattern(longdash)) ///
		(line ue3_rate year if nuts=="CA: New Brunswick" & year>=1970 & year<=1995, lcolor(blue) lpattern(longdash_dot)) ///
		(scatter ue3_rate year if nuts=="CA: Newfoundland and Labrador" & year>=1970 & year<=1995, msymbol(d) mfcolor(white) connect(direct) mcolor(cyan) lcolor(cyan) lpattern(solid)) ///
		(line ue3_rate year if nuts=="CA: Nova Scotia" & year>=1970 & year<=1995, lcolor(orange) lpattern(dash)) ///
		(line ue3_rate year if nuts=="CA: Ontario" & year>=1970 & year<=1995, lcolor(brown) lpattern(longdash)) ///
		(line ue3_rate year if nuts=="CA: Prince Edward Island" & year>=1970 & year<=1995, lcolor(pink) lpattern(dash_dot)) ///
		(scatter ue3_rate year if nuts=="CA: Quebec" & year>=1970 & year<=1995,  msymbol(x) connect(direct) mcolor(magenta) lcolor(magenta) lpattern(solid)) ///
		(scatter ue3_rate year if nuts=="CA: Saskatchewan" & year>=1970 & year<=1995, msymbol(o) connect(direct) mcolor(emerald) lcolor(emerald) lpattern(solid)) ///
		, xlabel(1970(5)1995) ylabel(0(2)18) ytitle("unemployment rate" " ") xtitle("") ///
		legend( label(1 "Alberta") ///
				label(2 "British Columbia") /// 
				label(3 "Manitoba") /// 
				label(4 "New Brunswick") /// 
				label(5 "Newfoundland") /// 
				label(6 "Nova Scotia") /// 
				label(7 "Ontario") /// 
				label(8 "Prince Edward Island") /// 
				label(9 "Quebec") /// 
				label(10 "Saskatchewan") /// 
				rows(4))    	///
		subtitle("Canada") ///		
		saving(fig_ts_CA.gph, replace)		
        graph export fig_ts_CA.emf, replace
                        
									
				

			
 *==============================================================
*					Austria
*==============================================================
cd "C:\Dropbox\Oli\Hysteresis\workfiles_Oct_2013\"
use wf_step1001.dta, clear
capture cd "C:\Dropbox\Oli\Hysteresis\workfiles_Oct_2013\figures"

*** note that we exclude US and Canada from this
keep if country=="AT"
gen ue3_rate=ue2_rate
replace ue3_rate=ue_rate if ue3_rate==. & ue_rate~=.


keep country nuts ue3_rate age_total year

twoway 	(line ue3_rate year if nuts=="AT11" & year>=1970 & year<=1995, lcolor(green) lpattern(longdash)) ///
		(line ue3_rate year if nuts=="AT12" & year>=1970 & year<=1995, lcolor(red) lpattern(shortdash)) ///
		(line ue3_rate year if nuts=="AT13" & year>=1970 & year<=1995, lcolor(black) lwidth(thick)) ///
		(line ue3_rate year if nuts=="AT21" & year>=1970 & year<=1995, lcolor(blue) lpattern(longdash_dot)) ///
		(scatter ue3_rate year if nuts=="AT22" & year>=1970 & year<=1995, msymbol(d) mfcolor(white) connect(direct) mcolor(cyan) lcolor(cyan) lpattern(solid)) ///
		(line ue3_rate year if nuts=="AT31" & year>=1970 & year<=1995, lcolor(orange) lpattern(dash)) ///
		(line ue3_rate year if nuts=="AT32" & year>=1970 & year<=1995, lcolor(brown) lpattern(longdash)) ///
		(line ue3_rate year if nuts=="AT33" & year>=1970 & year<=1995, lcolor(pink) lpattern(dash_dot)) ///
		(scatter ue3_rate year if nuts=="AT34" & year>=1970 & year<=1995,  msymbol(x) connect(direct) mcolor(magenta) lcolor(magenta) lpattern(solid)) ///
		, xlabel(1970(5)1995) ylabel(0(2)10) ytitle("unemployment rate" " ") xtitle("") ///
		legend( label(1 "Burgenland") ///
				label(2 "Lower Austria ") /// 
				label(3 "Vienna") /// 
				label(4 "Carinthia") /// 
				label(5 "Styria") /// 
				label(6 "Upper Austria") /// 
				label(7 "Salzburg") /// 
				label(8 "Tyrol") /// 
				label(9 "Vorarlberg") /// 
				rows(4))   	///
		subtitle("Austria") ///		
		saving(fig_ts_AT.gph, replace)		
        graph export fig_ts_AT.emf, replace
                         
							
							


*==============================================================
*					Sweden
*==============================================================
cd "C:\Dropbox\Oli\Hysteresis\workfiles_Oct_2013\"
use wf_step1001.dta, clear
capture cd "C:\Dropbox\Oli\Hysteresis\workfiles_Oct_2013\figures"

*** note that we exclude US and Canada from this
keep if country=="SE"
gen ue3_rate=ue2_rate
replace ue3_rate=ue_rate if ue3_rate==. & ue_rate~=.


keep country nuts ue3_rate age_total year 

twoway 	(line ue3_rate year if nuts=="SE11" & year>=1970 & year<=1995, lcolor(green) lpattern(longdash)) ///
		(line ue3_rate year if nuts=="SE12" & year>=1970 & year<=1995, lcolor(red) lpattern(shortdash)) ///
		(line ue3_rate year if nuts=="SE21" & year>=1970 & year<=1995, lcolor(black) lwidth(thick)) ///
		(line ue3_rate year if nuts=="SE22" & year>=1970 & year<=1995, lcolor(blue) lpattern(longdash_dot)) ///
		(scatter ue3_rate year if nuts=="SE23" & year>=1970 & year<=1995, msymbol(d) mfcolor(white) connect(direct) mcolor(cyan) lcolor(cyan) lpattern(solid)) ///
		(line ue3_rate year if nuts=="SE31" & year>=1970 & year<=1995, lcolor(orange) lpattern(dash)) ///
		(line ue3_rate year if nuts=="SE32" & year>=1970 & year<=1995, lcolor(brown) lpattern(longdash)) ///
		(line ue3_rate year if nuts=="SE33" & year>=1970 & year<=1995, lcolor(pink) lpattern(dash_dot)) ///
		, xlabel(1970(5)1995) ylabel(0(2)12) ytitle("unemployment rate" " ") xtitle("") ///
		legend( label(1 "Stockholm") ///
				label(2 "East Middle Sweden ") /// 
				label(3 "Smland and the islands") /// 
				label(4 "South Sweden") /// 
				label(5 "West Sweden") /// 
				label(6 "North Middle Sweden ") /// 
				label(7 "Middle Norrland") /// 
				label(8 "Upper Norrland") /// 
				rows(4))  	///
		subtitle("Sweden") ///		
		saving(fig_ts_SE.gph, replace)		
    	graph export fig_ts_SE.emf, replace

				
				

*==============================================================
*					Netherlands
*==============================================================
cd "C:\Dropbox\Oli\Hysteresis\workfiles_Oct_2013\"
use wf_step1001.dta, clear
capture cd "C:\Dropbox\Oli\Hysteresis\workfiles_Oct_2013\figures"

*** note that we exclude US and Canada from this
keep if country=="NL"
gen ue3_rate=ue2_rate
replace ue3_rate=ue_rate if ue3_rate==. & ue_rate~=.


keep country nuts ue3_rate age_total year 

twoway 	(line ue3_rate year if nuts=="NL1" & year>=1970 & year<=1995, lcolor(green) lpattern(longdash)) ///
		(line ue3_rate year if nuts=="NL2" & year>=1970 & year<=1995, lcolor(red) lpattern(shortdash)) ///
		(line ue3_rate year if nuts=="NL3" & year>=1970 & year<=1995, lcolor(black) lwidth(thick)) ///
		(line ue3_rate year if nuts=="NL4" & year>=1970 & year<=1995, lcolor(blue) lpattern(longdash_dot)) ///
		, xlabel(1970(5)1995) ylabel(0(2)14) ytitle("unemployment rate" " ") xtitle("") ///
		legend( label(1 "Northern Netherlands") ///
				label(2 "Eastern Netherlands") /// 
				label(3 "Western Netherlands") /// 
				label(4 "Southern Netherlands 	") /// 
				rows(2))   	///
		subtitle("Netherlands") ///		
		saving(fig_ts_NL.gph, replace)		
 		graph export fig_ts_NL.emf, replace
  
				

*==============================================================
*					Spain
*==============================================================
cd "C:\Dropbox\Oli\Hysteresis\workfiles_Oct_2013\"
use wf_step1001.dta, clear
capture cd "C:\Dropbox\Oli\Hysteresis\workfiles_Oct_2013\figures"

*** note that we exclude US and Canada from this
keep if country=="ES"
gen ue3_rate=ue2_rate
replace ue3_rate=ue_rate if ue3_rate==. & ue_rate~=.


keep country nuts ue3_rate age_total year 


twoway 	(line ue3_rate year if nuts=="ES1" & year>=1970 & year<=1995, lcolor(green) lpattern(longdash)) ///
		(line ue3_rate year if nuts=="ES2" & year>=1970 & year<=1995, lcolor(red) lpattern(shortdash)) ///
		(line ue3_rate year if nuts=="ES3" & year>=1970 & year<=1995, lcolor(black) lwidth(thick)) ///
		(line ue3_rate year if nuts=="ES4" & year>=1970 & year<=1995, lcolor(blue) lpattern(longdash_dot)) ///
		(scatter ue3_rate year if nuts=="ES5" & year>=1970 & year<=1995, msymbol(d) mfcolor(white) connect(direct) mcolor(cyan) lcolor(cyan) lpattern(solid)) ///
		(line ue3_rate year if nuts=="ES6" & year>=1970 & year<=1995, lcolor(orange) lpattern(dash)) ///
		(line ue3_rate year if nuts=="ES7" & year>=1970 & year<=1995, lcolor(brown) lpattern(longdash)) ///
		, xlabel(1970(5)1995) ylabel(0(4)32) ytitle("unemployment rate" " ") xtitle("") ///
		legend( label(1 "Noroeste") ///
				label(2 "Noreste") /// 
				label(3 "Comunidad de Madrid") /// 
				label(4 "Centro)") /// 
				label(5 "Este") /// 
				label(6 "Sur") /// 
				label(7 "Canarias") /// 
				rows(4))  	///
		subtitle("Spain") ///		
		saving(fig_ts_ES.gph, replace)		
		graph export fig_ts_ES.emf, replace
   
				
				
*==============================================================
*					UK
*==============================================================
cd "C:\Dropbox\Oli\Hysteresis\workfiles_Oct_2013\"
use wf_step1001.dta, clear
capture cd "C:\Dropbox\Oli\Hysteresis\workfiles_Oct_2013\figures"

*** note that we exclude US and Canada from this
keep if country=="UK"
gen ue3_rate=ue2_rate
replace ue3_rate=ue_rate if ue3_rate==. & ue_rate~=.


keep country nuts ue3_rate age_total year 


twoway 	(line ue3_rate year if nuts=="UKC" & year>=1970 & year<=1995, lcolor(black) lwidth(thick)) ///
		(line ue3_rate year if nuts=="UKD" & year>=1970 & year<=1995, lcolor(red) lpattern(shortdash)) ///
		(line ue3_rate year if nuts=="UKE" & year>=1970 & year<=1995, lcolor(green) lpattern(longdash)) ///
		(line ue3_rate year if nuts=="UKF" & year>=1970 & year<=1995, lcolor(blue) lpattern(longdash_dot)) ///
		(scatter ue3_rate year if nuts=="UKG" & year>=1970 & year<=1995, msymbol(d) mfcolor(white) connect(direct) mcolor(cyan) lcolor(cyan) lpattern(solid)) ///
		(line ue3_rate year if nuts=="UKH" & year>=1970 & year<=1995, lcolor(orange) lpattern(dash)) ///
		(line ue3_rate year if nuts=="UKI" & year>=1970 & year<=1995, lcolor(brown) lpattern(longdash)) ///
		(line ue3_rate year if nuts=="UKJ" & year>=1970 & year<=1995, lcolor(pink) lpattern(dash_dot)) ///
		(scatter ue3_rate year if nuts=="UKK" & year>=1970 & year<=1995,  msymbol(x) connect(direct) mcolor(magenta) lcolor(magenta) lpattern(solid)) ///
		(scatter ue3_rate year if nuts=="UKL" & year>=1970 & year<=1995, msymbol(o) connect(direct) mcolor(emerald) lcolor(emerald) lpattern(solid)) ///
		(scatter ue3_rate year if nuts=="UKM" & year>=1970 & year<=1995, msymbol(t) mfcolor(white)  connect(direct) mcolor(black) lcolor(black) lpattern(dash)) ///		
		(scatter ue3_rate year if nuts=="UKN" & year>=1970 & year<=1995, msymbol(t) mfcolor(red)  connect(direct) mcolor(black) lcolor(red) lpattern(dash)) ///				
		, xlabel(1970(5)1995) ylabel(0(2)18) ytitle("unemployment rate" " ") xtitle("") ///
		legend( label(1 "N.E. England") ///
				label(2 "N.W. England") /// 
				label(3 "Yorkshire & Humber") /// 
				label(4 "E. Midlands") /// 
				label(5 "W. Midlands") /// 
				label(6 "E. England") /// 
				label(7 "Greater London") /// 
				label(8 "S.E. England") /// 
				label(9 "S.W. England") /// 
				label(10 "Wales") /// 
				label(11 "Scotland")  ///
				label(12 "N. Ireland")  ///
				rows(4))    	///
		subtitle("United Kingdom") ///		
		saving(fig_ts_UK.gph, replace)		
 		graph export fig_ts_UK.emf, replace
 
				

*==============================================================
*					Denmark
*==============================================================
cd "C:\Dropbox\Oli\Hysteresis\workfiles_Oct_2013\"
use wf_step1001.dta, clear
capture cd "C:\Dropbox\Oli\Hysteresis\workfiles_Oct_2013\figures"

*** note that we exclude US and Canada from this
keep if country=="DK"
gen ue3_rate=ue2_rate
replace ue3_rate=ue_rate if ue3_rate==. & ue_rate~=.


keep country nuts ue3_rate age_total year  nuts_level


twoway 	(line ue3_rate year if nuts=="DK01" & year>=1970 & year<=1995, lcolor(black) lwidth(thick)) ///
		(line ue3_rate year if nuts=="DK02" & year>=1970 & year<=1995, lcolor(red) lpattern(shortdash)) ///
		(line ue3_rate year if nuts=="DK03" & year>=1970 & year<=1995, lcolor(green) lpattern(longdash)) ///
		(line ue3_rate year if nuts=="DK04" & year>=1970 & year<=1995, lcolor(blue) lpattern(longdash_dot)) ///
		(scatter ue3_rate year if nuts=="DK05" & year>=1970 & year<=1995, msymbol(d) mfcolor(white) connect(direct) mcolor(cyan) lcolor(cyan) lpattern(solid)) ///
		, xlabel(1970(5)1995) ylabel(0(2)14) ytitle("unemployment rate" " ") xtitle("") ///
		legend( label(1 "Hovedstaden") ///
				label(2 "Zealand") ///
				label(3 "South") ///
				label(4 "Central") ///
				label(5 "North") /// 
				rows(1))  	///
		subtitle("Denmark") ///		
		saving(fig_ts_DK.gph, replace)		
		graph export fig_ts_DK.emf, replace
    
				

	
*==============================================================
*					Finland
*==============================================================
cd "C:\Dropbox\Oli\Hysteresis\workfiles_Oct_2013\"
use wf_step1001.dta, clear
capture cd "C:\Dropbox\Oli\Hysteresis\workfiles_Oct_2013\figures"

*** note that we exclude US and Canada from this
keep if country=="FI"
gen ue3_rate=ue2_rate
replace ue3_rate=ue_rate if ue3_rate==. & ue_rate~=.


keep country nuts ue2_rate ue3_rate age_total year  nuts_level
order country nuts ue2_rate ue3_rate age_total year  nuts_level

twoway 	(line ue3_rate year if nuts=="FI19" & year>=1970 & year<=1995, lcolor(black) lwidth(thick)) ///
		(line ue3_rate year if nuts=="FI1B" & year>=1970 & year<=1995, lcolor(red) lpattern(shortdash)) ///
		(line ue3_rate year if nuts=="FI1C" & year>=1970 & year<=1995, lcolor(green) lpattern(longdash)) ///
		(line ue3_rate year if nuts=="FI1D" & year>=1970 & year<=1995, lcolor(blue) lpattern(longdash_dot)) ///
		, xlabel(1970(5)1995) ylabel(0(2)14) ytitle("unemployment rate" " ") xtitle("") ///
		legend( label(1 "West (Lnsi-Suomi)") ///
				label(2 "South (Helsinki-Uusimaa)") ///
				label(3 "South (Etel-Suomi)") ///
				label(4 "North & East (Pohjois- ja It-Suomi)") ///
				rows(2))  	///
		subtitle("Finland") ///		
		saving(fig_ts_FI.gph, replace)		
		graph export fig_ts_FI.emf, replace
  
				

	
*==============================================================
*					Switzerland
*==============================================================
cd "C:\Dropbox\Oli\Hysteresis\workfiles_Oct_2013\"
use wf_step1001.dta, clear
capture cd "C:\Dropbox\Oli\Hysteresis\workfiles_Oct_2013\figures"

*** note that we exclude US and Canada from this
keep if smpl1==1

keep if country=="CH"
gen ue3_rate=ue2_rate
replace ue3_rate=ue_rate if ue3_rate==. & ue_rate~=.

keep country nuts ue3_rate age_total year

twoway 	(scatter ue3_rate year if nuts=="CH01" & year>=1970 & year<=1995, connect(direct) msymbol(O) mfcolor(white) mlwidth(thin) mcolor(black) msize(2) lcolor(black) lwidth(thick)) ///
		(scatter ue3_rate year if nuts=="CH02" & year>=1970 & year<=1995, connect(direct) msymbol(S) mcolor(red) mfcolor(white) lcolor(red) lpattern(shortdash)) ///
		(scatter ue3_rate year if nuts=="CH03" & year>=1970 & year<=1995, connect(direct) msymbol(T) mfcolor(white) mcolor(green) lcolor(green) lpattern(longdash)) ///
		(scatter ue3_rate year if nuts=="CH04" & year>=1970 & year<=1995, connect(direct) msymbol(X) mcolor(blue) lcolor(blue) lpattern(longdash_dot)) ///
		(scatter ue3_rate year if nuts=="CH05" & year>=1970 & year<=1995, connect(direct) msymbol(D) mfcolor(white) connect(direct) mcolor(cyan) lcolor(cyan) lpattern(solid)) ///
		(scatter ue3_rate year if nuts=="CH06" & year>=1970 & year<=1995, connect(direct) msymbol(O) mfcolor(orange) lcolor(orange) lpattern(dash)) ///
		(scatter ue3_rate year if nuts=="CH07" & year>=1970 & year<=1995, connect(direct) msymbol(T) mcolor(pink) mfcolor(white) lcolor(pink) lpattern(longdash)) ///
		, xlabel(1970(5)1995) ylabel(0(2)12) ytitle("unemployment rate" " ") xtitle("") ///
		legend( label(1 "Lake Geneva region") ///
				label(2 "Espace Mittelland") /// 
				label(3 "Northwestern Switzerland") /// 
				label(4 "Zurich") /// 
				label(5 "Eastern Switzerland") /// 
				label(6 "Central Switzerland") /// 
				label(7 "Ticino") /// 
				rows(4))	///
		subtitle("Switzerland") ///		
		saving(fig_ts_CH.gph, replace)		
		graph export fig_ts_CH.emf, replace
  	
  
	
								   
								   
	  
